import os
import sys

from flask import Flask, json, jsonify, request, render_template



app = Flask(__name__, static_folder="./build/static", template_folder="./build")

def get_file(filename):
    print(f'{filename}')
    try:
        with open( f'{filename}', 'r', encoding='utf8') as infile:
            file = json.load(infile)
    except Exception:
        return jsonify(reason='Not Found', message='Existing file not found.'), 404
    else:
        return file

def save_file(filename, data):
    try:
        with open(f'{filename}', 'w', encoding='utf8') as infile:
            json.dump(data, infile)
    except Exception:
        return (
            jsonify(reason='Internal Server Error', message='A fatal error occurred while trying to save line data'),
            500
        )

    return data, 200

@app.route("/")
def index():
    return render_template("index.html")
@app.errorhandler(404)
def not_found(e):
    return render_template("index.html")

@app.route('/api/camareas', methods=['GET', 'PUT'])
def camareas():
    if request.method == 'GET':
        return get_file('camareas.json')
    elif request.method == 'PUT':
        return save_file('camareas.json',request.json)
    else:
        return {'message': 'Method not allowed.'}, 405

@app.route('/api/sketchareas', methods=['GET', 'PUT'])
def sketchareas():
    if request.method == 'GET':
        return get_file('sketchareas.json')
    elif request.method == 'PUT':
        return save_file('sketchareas.json',request.json)
    else:
        return {'message': 'Method not allowed.'}, 405

@app.route('/api/camlines', methods=['GET', 'PUT'])
def camlines():
    if request.method == 'GET':
        return get_file('camlines.json')
    elif request.method == 'PUT':
        return save_file('camlines.json',request.json)
    else:
        return {'message': 'Method not allowed.'}, 405

@app.route('/api/sketchlines', methods=['GET', 'PUT'])
def sketchlines():
    if request.method == 'GET':
        return get_file('sketchlines.json')
    elif request.method == 'PUT':
        return save_file('sketchlines.json',request.json)
    else:
        return {'message': 'Method not allowed.'}, 405
    
if __name__ == '__main__':
    app.run(host='0.0.0.0', debug=False, port=80)
