export interface Camera {
  position: {
    x: number; //number in cm
    y: number; //number in cm
    z: number; //number in cm
  }
  orientation: {
    x: number; //deg
    y: number;
    z: number;
  }
}



interface Point {
  x: number; // pixel location
  y: number; // pixel location
}

export interface Coordinates {
  map: {
    points: Point[4]
  }
  image: {
    points: Point[4]
  }
}

export interface LensDistortion {
  camera_matrix: [
    number[]
  ];
  coefficients: number[];
}

interface Shape {
  points: Point[4];
  label?: string
}

interface Blackouts {
  blackouts: Shape[];
}

export interface Location {
  name: string;
  pixelLength: number; //pixel length in cm?
  locationMap: string; // Full location map URL (not required edge side)
}

interface Sign {
  name: string;
  id: string;
  width: number; //number in cm
  height: number; //number in cm
  floorDistance: number; //number in cm
  position: {
    x: number; //cm
    y: number; //cm
  }
  orientation: number; //degree;
}
// zone
export interface Zone {
  name: string;
  id: string;
  map: string; //Path to zone specific map.
  deviceID: string; //LT_...
  description: string;
  tags: string[];
  signage: Sign[];
}


export interface Line {
  points: Point[2]
}
