import React, { useState, useReducer } from 'react';

import {
  LineUI,
  LineReducer,
  LineSetContext,
} from 'scorer-ui-kit';
import Sidebar, { SidebarLink } from '../components/Sidebar';
import { Layout, Content, MainContainer } from '../components/Layout';


const Main: React.FC<{}> = () => {
  const [error] = useState<string | null>('');
  const [state, dispatch] = useReducer(LineReducer, []);
  const HOSTNAME = window.location.hostname;
  const imgsrc = 'http://'+HOSTNAME+':21001/api/v1/stacks/RTSPcam1/snapshot?p='+(new Date()).getTime();
  return (
    <Layout>
      <Sidebar>
        <SidebarLink to='/camareas' title='Cam Areas' />
        <SidebarLink to='/camlines' title='Cam Lines' />
        <SidebarLink to='/camareasrtc' title='Cam Areas(WebRTC)' />
        <SidebarLink to='/camlinesrtc' title='Cam Lines(WebRTC)' />
        <SidebarLink to='/sketchareas' title='Sketch Areas' />
        <SidebarLink to='/sketchlines' title='Sketch Lines' />
      </Sidebar>
      <MainContainer>
        <Content>
          {error && <div>{error}</div>}
          <LineSetContext.Provider value={{state, dispatch}}>
            <LineUI  options={{showSetIndex: true}} src={imgsrc} />
          </LineSetContext.Provider>
        </Content>
      </MainContainer>


    </Layout>
  );
};

export default Main;
