import sys
import os
import json
import math
from datetime import datetime, timedelta, timezone
import csv
import glob
import numpy as np

def intersect(p1, p2, p3, p4):
    tc1 = (p1[0] - p2[0]) * (p3[1] - p1[1]) + (p1[1] - p2[1]) * (p1[0] - p3[0])
    tc2 = (p1[0] - p2[0]) * (p4[1] - p1[1]) + (p1[1] - p2[1]) * (p1[0] - p4[0])
    td1 = (p3[0] - p4[0]) * (p1[1] - p3[1]) + (p3[1] - p4[1]) * (p3[0] - p1[0])
    td2 = (p3[0] - p4[0]) * (p2[1] - p3[1]) + (p3[1] - p4[1]) * (p3[0] - p2[0])
    return tc1*tc2<0 and td1*td2<0

if __name__ == '__main__':
    
    dirpath = 'data'
    duration = 5
    line_def_file = '03lines.json'
    
    JST = timezone(timedelta(hours=+9), 'JST')
    print(sys.argv[1]+"を集計しています・・")
    file_list = sorted(glob.glob('./'+dirpath+'/'+sys.argv[1]+'/raw_'+sys.argv[1]+'*.json'))
    print("対象ファイル一覧")
    for filename in file_list:
        print(filename)
    
    json_open = open(line_def_file, 'r')
    result_json_file = open('result_'+line_def_file[:len(line_def_file)-5]+'_'+sys.argv[1]+'.json', 'w')
    linedef = json.load(json_open)
    resultarr = {}
    for lineidx, line in enumerate(linedef['lines']):
        linename='lineID'+str(lineidx)
        print(linename)
        resultarr[linename]={}
        
    print("集計・・")
    for lineidx, line in enumerate(linedef['lines']):
        linename='lineID'+str(lineidx)
        print(linename)
        polygon = []
        print(line)
        for point in line['points']:
            polygon.append([point['x'],point['y']])

        for filename in file_list:
            print(linename+"_"+filename)
            if os.path.getsize(filename) == 0:
                continue
                
            raw_json_open = open(filename, 'r')
            raw_json = json.load(raw_json_open)
            
            for frame in raw_json:
                jptime = datetime.fromtimestamp(frame['frame_time'],JST)
                people = frame['objects']
                for person in people:
                    
                    #print(linename+'_'+person['tracking_id']+'_'+str(judgenum))
                    personpos = [(person["x0"]+person["x1"])/2,person["y1"]]
                    if person['tracking_id'] in resultarr[linename]:
                        if intersect(personpos,resultarr[linename][person['tracking_id']]['prev_pos'],polygon[0],polygon[1]):
                            resultarr[linename][person['tracking_id']]['passing_judge'] = True
                            resultarr[linename][person['tracking_id']]['passing_time'] = jptime.isoformat()
                        resultarr[linename][person['tracking_id']]['end_time'] = frame['frame_time']
                        resultarr[linename][person['tracking_id']]['end_time_jp'] = jptime.isoformat()
                    else:
                        resultarr[linename][person['tracking_id']]={'line':linename,'start_time_jp':jptime.isoformat(),'end_time_jp':jptime.isoformat(),'start_time':frame['frame_time'],'end_time':frame['frame_time'],'stream_id':frame['stream_id'],'passing_judge':False,'passing_time':0,'prev_pos':personpos}

    json.dump(resultarr,result_json_file)
    
    for linename, records in resultarr.items():
        print(linename)
        f = open(line_def_file[:len(line_def_file)-5]+"_"+sys.argv[1]+"_"+linename+".csv", 'w', encoding='utf-8', newline='')
        write = csv.writer(f)
        write.writerow(["stream_id","linename","tracking_id","start_time_jp","end_time_jp","passing_judge","passing_time"])
        for tracking_id, record in records.items():
            write.writerow([record['stream_id'],linename,tracking_id,record['start_time_jp'],record['end_time_jp'],record['passing_judge'],record['passing_time']])
        
        f.close()    